/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.defense;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.data.ModifierMaxLevel;
import slimeknights.tconstruct.library.modifiers.impl.IncrementalModifier;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.TinkerModifiers;

public abstract class AbstractProtectionModifier<T extends ModifierMaxLevel>
extends IncrementalModifier {
    private final TinkerDataCapability.TinkerDataKey<T> key;

    @Deprecated
    protected abstract T createData();

    protected T createData(EquipmentChangeContext context) {
        return this.createData();
    }

    @Deprecated
    protected void reset(T data) {
    }

    protected void reset(T data, EquipmentChangeContext context) {
        this.reset(data);
    }

    protected void set(T data, EquipmentSlot slot, float scaledLevel, EquipmentChangeContext context) {
        ((ModifierMaxLevel)data).set(slot, scaledLevel);
    }

    @Override
    public void onUnequip(IToolStackView tool, int level, EquipmentChangeContext context) {
        LivingEntity entity = context.getEntity();
        EquipmentSlot slot = context.getChangedSlot();
        if (ModifierUtil.validArmorSlot(tool, slot) && !entity.f_19853_.f_46443_) {
            context.getTinkerData().ifPresent(data -> {
                ModifierMaxLevel modData = (ModifierMaxLevel)data.get(this.key);
                if (modData != null) {
                    this.set(modData, slot, 0.0f, context);
                    if (modData.getMax() == 0.0f) {
                        this.reset(modData, context);
                    }
                }
            });
        }
    }

    @Override
    public void onEquip(IToolStackView tool, int level, EquipmentChangeContext context) {
        LivingEntity entity = context.getEntity();
        EquipmentSlot slot = context.getChangedSlot();
        if (!entity.f_19853_.f_46443_ && ModifierUtil.validArmorSlot(tool, slot) && !tool.isBroken()) {
            float scaledLevel = this.getScaledLevel(tool, level);
            context.getTinkerData().ifPresent(data -> {
                ModifierMaxLevel modData = (ModifierMaxLevel)data.get(this.key);
                if (modData == null) {
                    modData = this.createData(context);
                    data.put(this.key, modData);
                }
                this.set(modData, slot, scaledLevel, context);
            });
        }
    }

    public static void addResistanceTooltip(Modifier modifier, IToolStackView tool, int level, float multiplier, List<Component> tooltip) {
        if (tool.hasTag(TinkerTags.Items.ARMOR)) {
            float cap = Math.min(0.95f, 0.8f + (float)tool.getModifierLevel(TinkerModifiers.boundless.getId()) * 0.1f);
            tooltip.add((Component)modifier.applyStyle(new TextComponent(Util.PERCENT_BOOST_FORMAT.format(Math.min(modifier.getEffectiveLevel(tool, level) * multiplier / 25.0f, cap))).m_130946_(" ").m_7220_((Component)new TranslatableComponent(modifier.getTranslationKey() + ".resistance"))));
        }
    }

    public AbstractProtectionModifier(TinkerDataCapability.TinkerDataKey<T> key) {
        this.key = key;
    }
}

